// DeleteTimeZone.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteTimeZone.h"
#include <afxtempl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDeleteTimeZone dialog


CDeleteTimeZone::CDeleteTimeZone(CWnd* pParent /*=NULL*/)
	: CDialog(CDeleteTimeZone::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeleteTimeZone)
	//}}AFX_DATA_INIT
}

CDeleteTimeZone ::CDeleteTimeZone(IApplication *pApp):CDialog(CDeleteTimeZone::IDD, NULL)
{
	pApplication = pApp;
}
void CDeleteTimeZone::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeleteTimeZone)
	DDX_Control(pDX, IDC_RADIO_ADVS, m_ADVSelect);
	DDX_Control(pDX, IDC_RADIO_CARDS, m_CardsSelect);
	DDX_Control(pDX, IDC_RADIO_ACTIONGROUPS, m_ActionGroupSelect);
	DDX_Control(pDX, IDC_RADIO_ACCESSLEVELS, m_AccessLevelSelect);
	DDX_Control(pDX, IDC_RADIO_OPERATOR, m_OperatorSelect);
	DDX_Control(pDX, IDC_RADIO_PANELS, m_PanelSelect);
	DDX_Control(pDX, IDC_REASSIG_TZLIST, m_ReassignTZList);
	DDX_Control(pDX, IDC_TZLIST, m_TZList);
	DDX_Control(pDX, IDC_ASSOCIATE_PANELS, m_PanelList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	//}}AFX_DATA_MAP
}
void CDeleteTimeZone :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release(); 
		}
	UpdateData(FALSE);
//	m_AcctList.SetCurSel(0);
}

void CDeleteTimeZone ::LoadTimeZones()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		long lAccountID = _wtoi(sAcctName);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetTimeZonesByAccountName(bstrAcctName,&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray sa(vTZs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_TZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_TZList.SetCurSel(0);
}
void CDeleteTimeZone ::LoadOperatorReassignTimeZones()
{
	int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		long lAccountID = _wtoi(sAcctName);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		long lTZID = 0;
		int index_TZ = m_TZList.GetCurSel();
		CString sTZName;
		if (index_TZ <0)
			lTZID = 0;
		else
		{
			m_TZList.GetLBText(index_TZ,sTZName);
			lTZID = _wtoi(sTZName);
		
		}
		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetTZsForOperatorReassign(lTZID,&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			return;
		}
		int none = 0;
		CString sNone;
		sNone.Format(L"%d", none);
		m_ReassignTZList.AddString(sNone);
		long uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray sa(vTZs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_ReassignTZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_ReassignTZList.SetCurSel(0);
}

void CDeleteTimeZone ::LoadReassignTimeZones()
{
	int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		long lAccountID = _wtoi(sAcctName);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		long lTZID = 0;
		int index_TZ = m_TZList.GetCurSel();
		CString sTZName;
		if (index_TZ <0)
			lTZID = 0;
		else
		{
			m_TZList.GetLBText(index_TZ,sTZName);
			lTZID = _wtoi(sTZName);
		
		}
		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetTZsForReassign(lAccountID,lTZID,&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			return;
		}
		int none = 0;
		CString sNone;
		sNone.Format(L"%d", none);
		m_ReassignTZList.AddString(sNone);
		long uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray sa(vTZs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_ReassignTZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_ReassignTZList.SetCurSel(0);
}
BEGIN_MESSAGE_MAP(CDeleteTimeZone, CDialog)
	//{{AFX_MSG_MAP(CDeleteTimeZone)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_BN_CLICKED(ID_DELETE_TZ, OnDeleteTz)
	ON_BN_CLICKED(ID_ISOLATE, OnIsolate)
	ON_BN_CLICKED(ID_REASSIGN, OnReassign)
	ON_BN_CLICKED(IDC_RADIO_ACCESSLEVELS, OnAssociationSelect)
	ON_BN_CLICKED(IDC_RADIO_ACTIONGROUPS, OnAssociationSelect)
	ON_BN_CLICKED(IDC_RADIO_ADVS, OnAssociationSelect)
	ON_BN_CLICKED(IDC_RADIO_CARDS, OnAssociationSelect)
	ON_BN_CLICKED(IDC_RADIO_OPERATOR, OnAssociationSelect)
	ON_BN_CLICKED(IDC_RADIO_PANELS, OnAssociationSelect)
	ON_CBN_SELCHANGE(IDC_TZLIST, OnSelchangeTZlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeleteTimeZone message handlers

BOOL CDeleteTimeZone::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts();
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDeleteTimeZone::OnSelchangeAcctlist() 
{
	m_PanelList.ResetContent();
	m_TZList.ResetContent();
	LoadTimeZones();
}

void CDeleteTimeZone::OnDeleteTz() 
{
		BSTR bstrAcctName;
		BSTR bstrTZName;
		long lTimeZoneID = 0;

		UpdateData(TRUE);
	//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		
	//select time zone from List
		int index_TZ = m_TZList.GetCurSel();
		CString sTZID;
		if (index_TZ <0)
			bstrTZName = SysAllocString(L"");
		else
		{
			m_TZList.GetLBText(index_TZ,sTZID);
			bstrTZName = sTZID.AllocSysString();
			lTimeZoneID = _wtoi(sTZID);
		}
		//delete the time zone
		long lstatus;
		pApplication->DeleteTimeZone(lTimeZoneID,&lstatus);
		
		if (lstatus == 605)
		{
			AfxMessageBox(L"Invalid Time zone");
			return;
		}
		if (lstatus == 606)
		{

			AfxMessageBox(L"Time zone is Associated with Panels");
			return;
		}
		if ( lstatus == 604)
		{
			AfxMessageBox(L"System Time zone can not be deleted");
			return;
		}
		if ( lstatus == 609)
		{
			AfxMessageBox(L"Time zone is Associated with operators");
			return;
		}
		if ( lstatus == 610)
		{
			AfxMessageBox(L"Time zone is Associated with action messages.");
			return;
		}
		if ( lstatus == 611)
		{
			AfxMessageBox(L"Time zone is Associated with access levels");
			return;
		}
		if ( lstatus == 615)
		{
			AfxMessageBox(L"Time zone is Associated with ADVs");
			return;
		}
		if ( lstatus == 1)
		{
			AfxMessageBox(L"Time zone Deletion Failed");
			return;	
		}
		else
		{
			AfxMessageBox(L"Time zone Deletion Succeded");
			CDialog::OnOK();
		}	
}

void CDeleteTimeZone::OnIsolate() 
{
	m_PanelList.ResetContent();
	m_ReassignTZList.ResetContent();
//	m_BtnReassign.EnableWindow(TRUE);
	long lAcctID = 0;
	int index_Account = m_AcctList.GetCurSel();
	CString sAcctName;
	if(index_Account <0)
	{
		lAcctID = 0;
	}
	else
	{
		m_AcctList.GetLBText(index_Account,sAcctName);
		lAcctID = _wtoi(sAcctName);
	}
	long lTZID = 0;
	int index_TZ = m_TZList.GetCurSel();
	CString sTZName;
	if (index_TZ <0)
		lTZID = 0;
	else
	{
		m_TZList.GetLBText(index_TZ,sTZName);
		lTZID = _wtoi(sTZName);
		
	}
	if(m_PanelSelect.GetCheck() == 1)
	{
	_variant_t vPanels;
	vPanels.Clear();
	long lStatus;
	pApplication->IsolatePanelsForTZDelete(lAcctID,lTZID,&vPanels,&lStatus);
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		else
		{
			if(vPanels.vt == VT_EMPTY || vPanels.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No panels Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vPanels);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			long lPanelID = 0;
			BSTR bstrPanelName = SysAllocString(L"");
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&bstrPanelName);
				CString sPanel = CString(bstrPanelName);
				m_PanelList.AddString(sPanel);
			}
		}	
	}
	if(m_OperatorSelect.GetCheck() == 1)
	{
		_variant_t vOperators;
		vOperators.Clear();
		long lStatus;
		pApplication->IsolateOperatorsForTZReassign(lTZID,&vOperators,&lStatus);
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		else
		{
			if(vOperators.vt == VT_EMPTY || vOperators.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No operators Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vOperators);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			BSTR bstrOperatorName = SysAllocString(L"");
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&bstrOperatorName);
				CString sOperator = CString(bstrOperatorName);
				m_PanelList.AddString(sOperator);
			}
		}	
		LoadOperatorReassignTimeZones();
	}
	if(m_AccessLevelSelect.GetCheck() == 1)
	{
		_variant_t vAccessLevels;
		vAccessLevels.Clear();
		long lStatus;
		pApplication->IsolateAccessLevelsForTZReassign(lAcctID,lTZID,&vAccessLevels,&lStatus);
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		else
		{
			if(vAccessLevels.vt == VT_EMPTY || vAccessLevels.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No access levels Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vAccessLevels);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			long lAccessLevelID = 0;
			BSTR bstrAccessLevelName = SysAllocString(L"");
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&bstrAccessLevelName);
				CString sAccessLevelName = CString(bstrAccessLevelName);
				m_PanelList.AddString(sAccessLevelName);
			}
		}	
		LoadReassignTimeZones();
	}
	if(m_ActionGroupSelect.GetCheck() == 1)
	{
		_variant_t vActionGroupss;
		vActionGroupss.Clear();
		long lStatus;
		pApplication->IsolateActionGroupsForTZReassign(lAcctID,lTZID,&vActionGroupss,&lStatus);
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		else
		{
			if(vActionGroupss.vt == VT_EMPTY || vActionGroupss.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No action groups Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vActionGroupss);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			long lActionGroupID = 0;
			BSTR bstrActionGroupName = SysAllocString(L"");
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&bstrActionGroupName);
				CString sAction = CString(bstrActionGroupName);
				m_PanelList.AddString(sAction);
			}
		}	
		LoadReassignTimeZones();
	}
	if(m_ADVSelect.GetCheck() == 1)
	{
		_variant_t vADVs;
		vADVs.Clear();
		long lStatus;
		pApplication->IsolateADVsForTZReassign(lAcctID, lTZID,&vADVs,&lStatus);
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		else
		{
			if(vADVs.vt == VT_EMPTY || vADVs.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No ADVs Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vADVs);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			long lActionGroupID = 0;
			BSTR bstrADVName = SysAllocString(L"");
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&bstrADVName);
				CString sADV = CString(bstrADVName);
				m_PanelList.AddString(sADV);
			}
		}	
		LoadReassignTimeZones();
	}
	if(m_CardsSelect.GetCheck() == 1)
	{
		_variant_t vCards;
		vCards.Clear();
		long lStatus;
		pApplication->IsolateCardsForTZReassign(lAcctID,lTZID,&vCards,&lStatus);
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		else
		{
			if(vCards.vt == VT_EMPTY || vCards.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No cards Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vCards);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			BSTR sCardno = SysAllocString(L"");
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&sCardno);

				//AfxMessageBox(sCardno);
				CString scard = CString(sCardno);
				
				m_PanelList.AddString(scard);
			}
		}	
		LoadReassignTimeZones();
	}
}

void CDeleteTimeZone::OnReassign() 
{
	long lAcctID = 0;
	int index_Account = m_AcctList.GetCurSel();
	CString sAcctName;
	if(index_Account <0)
	{
		lAcctID = 0;
	}
	else
	{
		m_AcctList.GetLBText(index_Account,sAcctName);
		lAcctID = _wtoi(sAcctName);
	}
	long lTZID = 0;
	int index_TZ = m_TZList.GetCurSel();
	CString sTZName;
	if (index_TZ <0)
		lTZID = 0;
	else
	{
		m_TZList.GetLBText(index_TZ,sTZName);
		lTZID = _wtoi(sTZName);
		
	}
	long lReassignTZID = 0;
	index_TZ = m_ReassignTZList.GetCurSel();
	CString sReassignTZName;
	if (index_TZ <0)
		lReassignTZID = 0;
	else
	{
		m_ReassignTZList.GetLBText(index_TZ,sReassignTZName);
		lReassignTZID = _wtoi(sReassignTZName);
		
	}
	if(m_PanelSelect.GetCheck() == 1)
	{
		CArray<int,int> sels;
		VARIANT vPanels;
		int n = m_PanelList.GetSelCount();
		COleSafeArray saPanels;
		saPanels.CreateOneDim(VT_BSTR,n);
		sels.SetSize(n);
		m_PanelList.GetSelItems(n, sels.GetData());
		if(n<=0)
		{
			AfxMessageBox(L"Please select atleast one panel");
			return;
		}
		for(long i = 0; i < n; i++)                                                  
		{                                                      
			CString sPanelName;       
			BSTR bstrPanelName;
			m_PanelList.GetText(sels[i], sPanelName);
			
			bstrPanelName = sPanelName.AllocSysString();
			saPanels.PutElement(&i,static_cast<BSTR>(bstrPanelName));
		}
		vPanels = saPanels.Detach();
		long lStatus = 0;
		pApplication->DeletePanelTZ(lAcctID,lTZID,&vPanels,&lStatus);
		if (lStatus == 105)
		{
			AfxMessageBox(L"Invalid account");
			return;
		}
		if ( lStatus == 501)
		{
			AfxMessageBox(L"Panel is Invalid");
			return;
		}
		if ( lStatus == 611)
		{
			AfxMessageBox(L"Time zone is Associated with access levels");
			return;
		}
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		if ( lStatus == 604)
		{
			AfxMessageBox(L"System TZ cannot be Removed");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone deletion from panel Failed");
			return;
		}
		if(lStatus == 0)
		{
			AfxMessageBox(L"Time Zone deletion from panel succeeded");
			//CDialog::OnOK();
		}


	}
	if(m_OperatorSelect.GetCheck() == 1)
	{
		
		CArray<int,int> sels;
		VARIANT vOperators;
		int n = m_PanelList.GetSelCount();
		COleSafeArray saOperators;
		saOperators.CreateOneDim(VT_BSTR,n);
		sels.SetSize(n);
		m_PanelList.GetSelItems(n, sels.GetData());
		if(n<=0)
		{
			AfxMessageBox(L"Please select atleast one operator");
			return;
		}
		for(long i = 0; i < n; i++)                                                  
		{                                                      
			CString sOperatorName;       
			BSTR bstrOperatorName;
			m_PanelList.GetText(sels[i],sOperatorName);
			
			bstrOperatorName = sOperatorName.AllocSysString();
			saOperators.PutElement(&i,static_cast<BSTR>(bstrOperatorName));
		}

		vOperators = saOperators.Detach();
		long lStatus = 0;
		pApplication->ReassignOperatorTZ(lReassignTZID,&vOperators,&lStatus);
		if (lStatus == 105)
		{
			AfxMessageBox(L"Invalid account");
			return;
		}
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		if ( lStatus == 617)
		{
			AfxMessageBox(L"Operator is Invalid");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone reassign to operator Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time zone reassign to operator succeeded");
			//CDialog::OnOK();
		}
	}
	if(m_AccessLevelSelect.GetCheck() == 1)
	{
		CArray<int,int> sels;
		VARIANT vAccessLevels;
		int n = m_PanelList.GetSelCount();
		COleSafeArray saAccessLevels;
		saAccessLevels.CreateOneDim(VT_INT,n);
		sels.SetSize(n);
		m_PanelList.GetSelItems(n, sels.GetData());
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAcctID,&bstrAcctName);
		if(n<=0)
		{
			AfxMessageBox(L"Please select atleast one accesslevel");
			return;
		}
		for(long i = 0; i < n; i++)                                                  
		{                
			CString sAccessLevelName;       
			BSTR bstrAccessLevelName;
			m_PanelList.GetText(sels[i], sAccessLevelName);
			bstrAccessLevelName = sAccessLevelName.AllocSysString();
			//saAccessLevels.PutElement(&i,static_cast<BSTR>(bstrAccessLevelName));

			_variant_t vAccl;
			vAccl.Clear();
			pApplication->GetAccessLevelByName(bstrAccessLevelName,bstrAcctName, &vAccl);
			if(vAccl.vt == VT_EMPTY)
			{
				AfxMessageBox(L"Time zone reassign to accesslevel Failed");
				return;
			}
			if( vAccl.vt & VT_DISPATCH)
			{
				long i = 0;
				IAccessLevelPtr pAccl(vAccl.pdispVal);
				long lAcclID = pAccl->AccessLevelID;
				saAccessLevels.PutElement(&i,static_cast<long *>(&lAcclID));
			}
		}
		vAccessLevels = saAccessLevels.Detach();
		long lStatus = 0;
		pApplication->ReassignAccessLevelTZ(lAcctID,lTZID,lReassignTZID,&vAccessLevels,&lStatus);
		if (lStatus == 105)
		{
			AfxMessageBox(L"Invalid account");
			return;
		}
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		if ( lStatus == 619)
		{
			AfxMessageBox(L"This time zone is already configured to the access level");
			return;
		}
		if ( lStatus == 201)
		{
			AfxMessageBox(L"Invalid Access Level");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone reassign to accesslevel Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time zone reassign to accesslevel succeeded");
			//CDialog::OnOK();
		}
	}
	if(m_ActionGroupSelect.GetCheck() == 1)
	{
		CArray<int,int> sels;
		VARIANT vActionGroups;
		int n = m_PanelList.GetSelCount();
		COleSafeArray saActionGroups;
		saActionGroups.CreateOneDim(VT_BSTR,n);
		sels.SetSize(n);
		m_PanelList.GetSelItems(n, sels.GetData());
		if(n<=0)
		{
			AfxMessageBox(L"Please select atleast one action group");
			return;
		}
		for(long i = 0; i < n; i++)                                                  
		{                             
			CString sActionGroupName;       
			BSTR bstrActionGroupName;
			m_PanelList.GetText(sels[i], sActionGroupName);
			bstrActionGroupName = sActionGroupName.AllocSysString();
			saActionGroups.PutElement(&i,static_cast<BSTR>(bstrActionGroupName));
		}
		vActionGroups = saActionGroups.Detach();
		long lStatus = 0;
		pApplication->ReassignActionGroupTZ(lAcctID,lTZID,lReassignTZID,&vActionGroups,&lStatus);
		if (lStatus == 105)
		{
			AfxMessageBox(L"Invalid account");
			return;
		}
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		if ( lStatus == 618)
		{
			AfxMessageBox(L"Invalid Action Group");
			return;
		}
		if ( lStatus == 619)
		{
			AfxMessageBox(L"This time zone is already configured to the action group");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone reassign to action group Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time zone reassign to action group succeeded");
			//CDialog::OnOK();
		}
	}
	if(m_CardsSelect.GetCheck() == 1)
	{
		CArray<int,int> sels;
		VARIANT vAccessLevels;
		int n = m_PanelList.GetSelCount();
		COleSafeArray saAccessLevels;
		saAccessLevels.CreateOneDim(VT_BSTR,n);
		sels.SetSize(n);
		m_PanelList.GetSelItems(n, sels.GetData());
		if(n<=0)
		{
			AfxMessageBox(L"Please select atleast one card");
			return;
		}
		for(long i = 0; i < n; i++)                                                  
		{                                                      
			CString sCardnum;       
			BSTR bstrCardnum;
			m_PanelList.GetText(sels[i], sCardnum);
			
			bstrCardnum = sCardnum.AllocSysString();
			saAccessLevels.PutElement(&i,static_cast<BSTR>(bstrCardnum));
		}
		vAccessLevels = saAccessLevels.Detach();
		long lStatus = 0;
		pApplication->ReassignCardTZ(lAcctID,lTZID,lReassignTZID,&vAccessLevels,&lStatus);
		if (lStatus == 105)
		{
			AfxMessageBox(L"Invalid account");
			return;
		}
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		if ( lStatus == 619)
		{
			AfxMessageBox(L"This time zone is already configured to the card");
			return;
		}
		if ( lStatus == 201)
		{
			AfxMessageBox(L"Invalid Access Level");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone reassign to card Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time zone reassign to card succeeded");
			//CDialog::OnOK();
		}
	}
	if(m_ADVSelect.GetCheck() == 1)
	{
		CArray<int,int> sels;
		VARIANT vADVs;
		int n = m_PanelList.GetSelCount();
		COleSafeArray saADVs;
		saADVs.CreateOneDim(VT_BSTR,n);
		sels.SetSize(n);
		m_PanelList.GetSelItems(n, sels.GetData());
		if(n<=0)
		{
			AfxMessageBox(L"Please select atleast one action group");
			return;
		}
		for(long i = 0; i < n; i++)                                                  
		{                             
			CString sADVName;       
			BSTR bstrADVName;
			m_PanelList.GetText(sels[i], sADVName);
			bstrADVName = sADVName.AllocSysString();
			saADVs.PutElement(&i,static_cast<BSTR>(bstrADVName));
		}
		vADVs = saADVs.Detach();
		long lStatus = 0;
		pApplication->ReassignADVTZ(lAcctID,lTZID,lReassignTZID,&vADVs,&lStatus);
		if (lStatus == 105)
		{
			AfxMessageBox(L"Invalid account");
			return;
		}
		if ( lStatus == 605)
		{
			AfxMessageBox(L"Invalid time zone");
			return;
		}
		if ( lStatus == 619)
		{
			AfxMessageBox(L"This time zone is already configured to the ADV");
			return;
		}
		if ( lStatus == 618)
		{
			AfxMessageBox(L"Invalid Action Group for the ADV");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time zone reassign to action group Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time zone reassign to action group succeeded");
			//CDialog::OnOK();
		}
	}
	
	// Refresh all the Associations -- Guru
	OnIsolate();
}


void CDeleteTimeZone::OnAssociationSelect()
{
	m_PanelList.ResetContent();
	m_ReassignTZList.ResetContent();
	UpdateData(FALSE);
}

void CDeleteTimeZone::OnSelchangeTZlist() 
{
	m_PanelList.ResetContent();
	m_ReassignTZList.ResetContent();
	UpdateData(FALSE);
}
